local require = GLOBAL.require;
modimport("libs/utils.lua")
local ArrowWidget = require "widgets/arrowwidget"

--make mod env available
GLOBAL.package.loaded["healthregen.modenv"] = env

local widget

local function InitArrowWidget(inst) 
	inst:ListenForEvent("healthregen", function(inst, data)
		if(widget) then
			if(not data.show) then
				widget:ShowArrow(false)
			else
				--TODO: Disable the arrow when sleeping (see: 'widgets/healtbadge')
				local dont_show = (inst.IsFreezing ~= nil and inst:IsFreezing()) or
        			(inst.IsOverheating ~= nil and inst:IsOverheating()) or
        			(inst.components.hunger ~= nil and inst.components.hunger:IsStarving()) or
        			(inst.components.health ~= nil and inst.components.health.takingfiredamage) or
        			(inst.IsBeaverStarving ~= nil and inst:IsBeaverStarving()) or inst:HasTag("playerghost")
				widget:ShowArrow(data.show and not dont_show)
			end
		end
	end)
end

local function CreateArrowWidget(self)
	--removes the sanity arrow (only needed for sanity regen)
	--self.brain.sanityarrow:GetAnimState():SetBank("")
	--brain.sanityarrow:GetAnimState():SetBuild("")

	widget = self:AddChild(ArrowWidget())
	widget:SetPosition(self.heart:GetPosition())
end

AddPlayerComponent("health_regeneration", nil)

if GetModConfigData("REGEN_WIDGET_ENABLED") then
	AddClassPostConstruct("widgets/statusdisplays", CreateArrowWidget)
	AddPlayerPostInitFunction(InitArrowWidget)
end